/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.debug.VoicechatUncaughtExceptionHandler;
import de.maxhenkel.voicechat.natives.OpusManager;
import de.maxhenkel.voicechat.plugins.ClientPluginManager;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.MicrophoneProcessor;
import de.maxhenkel.voicechat.voice.client.PTTMicrophoneProcessor;
import de.maxhenkel.voicechat.voice.client.PositionalAudioUtils;
import de.maxhenkel.voicechat.voice.client.VoiceMicrophoneProcessor;
import de.maxhenkel.voicechat.voice.client.microphone.Microphone;
import de.maxhenkel.voicechat.voice.client.microphone.MicrophoneManager;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_310;

public class MicThread
extends Thread {
    @Nullable
    private final ClientVoicechat client;
    @Nullable
    private final ClientVoicechatConnection connection;
    @Nullable
    private Microphone mic;
    @Nullable
    private MicrophoneException microphoneError;
    private boolean running;
    private boolean microphoneLocked;
    private final OpusEncoder encoder;
    private MicrophoneProcessor microphoneProcessor;
    private final Consumer<MicrophoneException> onError;
    private boolean hasSentAudio;
    private final AtomicLong sequenceNumber = new AtomicLong();
    private volatile boolean stopPacketSent = true;

    public MicThread(@Nullable ClientVoicechat client, @Nullable ClientVoicechatConnection connection, Consumer<MicrophoneException> onError) {
        this.client = client;
        this.connection = connection;
        this.onError = onError;
        this.running = true;
        this.encoder = OpusManager.createEncoder(connection == null ? ServerConfig.Codec.VOIP.getMode() : connection.getData().getCodec().getMode());
        this.microphoneProcessor = this.createMicrophoneProcessor();
        this.setDaemon(true);
        this.setName("MicrophoneThread");
        this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
    }

    private MicrophoneProcessor createMicrophoneProcessor() {
        MicrophoneActivationType type = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get();
        if (MicrophoneActivationType.VOICE.equals((Object)type)) {
            return new VoiceMicrophoneProcessor();
        }
        return new PTTMicrophoneProcessor();
    }

    public void getError(Consumer<MicrophoneException> onError) {
        if (this.microphoneError != null) {
            onError.accept(this.microphoneError);
        }
    }

    @Override
    public void run() {
        Microphone mic = this.getMic();
        if (mic == null) {
            return;
        }
        while (this.running) {
            MicrophoneActivationType type = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get();
            if (!type.equals((Object)this.microphoneProcessor.getActivationType())) {
                this.microphoneProcessor.close();
                this.microphoneProcessor = this.createMicrophoneProcessor();
            }
            if (this.connection != null) {
                this.connection.checkTimeout();
                if (!this.running) break;
            }
            if (this.microphoneLocked || ClientManager.getPlayerStateManager().isDisabled()) {
                this.flushIfNeeded();
                if (!this.microphoneLocked && ClientManager.getPlayerStateManager().isDisabled()) {
                    this.microphoneProcessor.reset();
                    if (mic.isStarted()) {
                        mic.stop();
                    }
                }
                Utils.sleep(10);
                continue;
            }
            short[] processed = this.pollProcessedAudio(false);
            if (processed == null) continue;
            if (!this.microphoneProcessor.shouldTransmitAudio()) {
                processed = null;
            }
            this.sendAudio(processed, this.microphoneProcessor.isWhispering());
        }
    }

    @Nullable
    public short[] pollMic() {
        Microphone mic = this.getMic();
        if (mic == null) {
            throw new IllegalStateException("No microphone available");
        }
        if (!mic.isStarted()) {
            mic.start();
        }
        if (mic.available() < 960) {
            Utils.sleep(5);
            return null;
        }
        return mic.read();
    }

    @Nullable
    public short[] pollProcessedAudio(boolean testing) {
        short[] audio = this.pollMic();
        if (audio == null) {
            return null;
        }
        this.microphoneProcessor.process(audio, testing);
        return audio;
    }

    @Nullable
    private Microphone getMic() {
        if (!this.running) {
            return null;
        }
        if (this.mic == null) {
            try {
                this.mic = MicrophoneManager.createMicrophone();
                class_310.method_1551().execute(ClientManager.instance()::checkMicrophonePermissions);
            }
            catch (MicrophoneException e) {
                this.onError.accept(e);
                this.microphoneError = e;
                this.running = false;
                return null;
            }
        }
        return this.mic;
    }

    private void flush() {
        this.sendStopPacket();
        if (!this.encoder.isClosed()) {
            this.encoder.resetState();
        }
        if (this.client == null) {
            return;
        }
        AudioRecorder recorder = this.client.getRecorder();
        if (recorder == null) {
            return;
        }
        recorder.flushChunkThreaded(class_310.method_1551().method_1548().method_1677().getId());
    }

    private void sendAudio(@Nullable short[] rawAudio, boolean whispering) {
        short[] mergedAudio = ClientPluginManager.instance().onMergeClientSound(rawAudio);
        if (mergedAudio == null) {
            this.flushIfNeeded();
            return;
        }
        short[] finalAudio = ClientPluginManager.instance().onClientSound(mergedAudio, whispering);
        if (finalAudio == null) {
            this.flushIfNeeded();
            return;
        }
        this.sendAudioPacket(finalAudio, whispering);
        this.hasSentAudio = true;
    }

    private void flushIfNeeded() {
        if (!this.hasSentAudio) {
            return;
        }
        this.flush();
        this.hasSentAudio = false;
    }

    public boolean isTalking() {
        return !this.microphoneLocked && this.microphoneProcessor.shouldTransmitAudio();
    }

    public boolean isWhispering() {
        return this.microphoneProcessor.isWhispering();
    }

    public boolean shouldTransmitAudio() {
        return this.microphoneProcessor.shouldTransmitAudio();
    }

    public void setMicrophoneLocked(boolean microphoneLocked) {
        this.microphoneLocked = microphoneLocked;
        this.microphoneProcessor.reset();
    }

    public void close() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (Thread.currentThread() != this) {
            try {
                this.join(100L);
            }
            catch (InterruptedException e) {
                Voicechat.LOGGER.error("Interrupted while waiting for mic thread to close", e);
            }
        }
        if (this.mic != null) {
            this.mic.close();
        }
        this.encoder.close();
        this.microphoneProcessor.close();
        this.flush();
    }

    public boolean isClosed() {
        return !this.running;
    }

    private void sendAudioPacket(short[] audio, boolean whispering) {
        if (this.connection != null && this.connection.isInitialized()) {
            byte[] encoded = this.encoder.encode(audio);
            this.connection.sendToServer(new NetworkMessage(new MicPacket(encoded, whispering, this.sequenceNumber.getAndIncrement())));
            this.stopPacketSent = false;
        }
        try {
            if (this.client != null && this.client.getRecorder() != null) {
                this.client.getRecorder().appendChunk(class_310.method_1551().method_1548().method_1677().getId(), System.currentTimeMillis(), PositionalAudioUtils.convertToStereo(audio));
            }
        }
        catch (IOException e) {
            Voicechat.LOGGER.error("Failed to record audio", e);
            this.client.setRecording(false);
        }
    }

    private void sendStopPacket() {
        if (this.stopPacketSent) {
            return;
        }
        if (this.connection == null || !this.connection.isInitialized()) {
            return;
        }
        this.connection.sendToServer(new NetworkMessage(new MicPacket(new byte[0], false, this.sequenceNumber.getAndIncrement())));
        this.stopPacketSent = true;
    }
}

